﻿/*
VERSION:		1.3
	1.3		Added "fps" variable
	1.2		Added checks for RAM.keys.up down left right...  which override the default controls while they exist
	
USAGE:
	#include "walkInertia.as"
	player_mc.walk_obj = makeWalk( player_mc );
	
	onUnload = function(){
		clearInterval(walk_obj.loopInterval);
	}
	
SETTINGS:
	walkSpeed		Maximum speed  (in pixels per frame)
	acel				Acelleration speed,  how many pixels the velocity increases per frame while a key is pressed
	decel				Deceleration speed, multiplier that reduces velocity per frame when no key is pressed
	
	up_key			Key code for moving UP
	down_key		Key code for moving DOWN
	left_key		Key code for moving LEFT
	right-Key		Key code for moving RIGHT
	
	
PROPERTIES:
	xVel				Current horizontal speed  (in pixels per frame)
	yVel				Current vertical speed  (in pixels per frame)
	
NOTES:
	This system has optional hooks for these collision and sprite systems:
		sprite.as
		WalkCollision.as
	It will use them if they're present.
	
ADDING COLLISION:
	A collision system can be added like this:
		walk_obj.collision = new Collision( player_mc, walk_obj, collision_array, -8, -8 );
	The walk_obj is this walk system.
*/
makeWalk = function( player_mc, playerSprite_mc )
{
	// create container
	var _this = new Object();
	var fps = 30;
	
	// walkSpeed
	_this.walkSpeed = 3;		// top speed
	_this.acel = 1.2;				// acelleration increment
	_this.decel = 0.5;			// brake multiplier
	
	_this.xVel = 0;					// How many pixels to move during this frame  (acts more like tiles per frame);
	_this.yVel = 0;					// 
	
	_this.playerSprite_mc = playerSprite_mc;
	
	//default walk buttons.  This allows the keys to be changed externally.
	_this.up_key = Key.UP;
	_this.down_key = Key.DOWN;
	_this.left_key = Key.LEFT;
	_this.right_key = Key.RIGHT;
	
	
	
	// Make a looping function
	_this.loop = function()
	{
		// detect vert keys
		if( Key.isDown(RAM.keys.down || _this.down_key) )
		{
			_this.playerSprite_mc.setParams({direction:"down"});
			if(_this.yVel < _this.walkSpeed)
				_this.yVel += _this.acel;
			if(_this.yVel > _this.walkSpeed)
				_this.yVel = _this.walkSpeed;
		}
		else if( Key.isDown(RAM.keys.up || _this.up_key) )
		{
			_this.playerSprite_mc.setParams({direction:"up"});
			if(_this.yVel > -_this.walkSpeed)
				_this.yVel -= _this.acel;
			if(_this.yVel < -_this.walkSpeed)
				_this.yVel = -_this.walkSpeed;
		}
		else
		{
			// decellerate
			if(Math.abs(_this.yVel) > 1)
			{
				_this.yVel *= _this.decel;
			}else{
				_this.yVel = 0;
			}
		}
		
		
		
		// detect horz keys
		if( Key.isDown(RAM.keys.right || _this.right_key) )
		{
			_this.playerSprite_mc.setParams({direction:"right"});
			if(_this.xVel < _this.walkSpeed)
				_this.xVel += _this.acel;
			if(_this.xVel > _this.walkSpeed)
				_this.xVel = _this.walkSpeed;
		}
		else if( Key.isDown(RAM.keys.left || _this.left_key) )
		{
			_this.playerSprite_mc.setParams({direction:"left"});
			if(_this.xVel > -_this.walkSpeed)
				_this.xVel -= _this.acel;
			if(_this.xVel < -_this.walkSpeed)
				_this.xVel = -_this.walkSpeed;
		}
		else
		{
			// decellerate
			if(Math.abs(_this.xVel) > 1)
			{
				_this.xVel *= _this.decel;
			}else{
				_this.xVel = 0;
			}
		}
		
		
		
		// Apply externally-defined collision
		_this.collision.run();
		
		// adjust walk speed
		var max = 5;
		var range = 4;
		var topSpeed = 10;		// used for animation
		//var moveSpeed = Math.sqrt(_this.xVel*_this.xVel + _this.yVel*_this.yVel);
		var moveSpeed = (Math.abs(_this.xVel)>Math.abs(_this.yVel)) ? Math.abs(_this.xVel) : Math.abs(_this.yVel);		// Use the fastest velocity
		var speedPercent = Math.abs(moveSpeed) / topSpeed;		// get percent
		var animSpeed = max - (range * speedPercent);
		var animSpeed = (animSpeed<1) ? 1 : animSpeed;		// enforce max speed
		_this.playerSprite_mc.setParams({delay:animSpeed});
		
		// start or stop the walk animation
		if ( Math.abs(_this.xVel) <= 0.05  &&
			 Math.abs(_this.yVel) <= 0.05 )
		{
			// is not moving
			_this.playerSprite_mc.setParams({isAnimating:false});
		}else{
			// is moving
			_this.playerSprite_mc.setParams({isAnimating:true});
		}
		
		// Move the player
		player_mc._x += _this.xVel;
		player_mc._y += _this.yVel;
		
	}// loop()
	_this.loopInterval = setInterval( _this.loop, 1000/fps );
	
	
	
	// return this system
	return _this;
}// makeWalk()